# test_sqlite.py - TEST SQLITE SETUP
from database_sqlite import StressDatabase

def test_sqlite():
    print("🧪 Testing SQLite Database...")
    
    # Create database instance
    db = StressDatabase()
    
    # Test connection
    if db.create_database():
        print("✅ SQLite database created successfully!")
        
        # Test adding sample data
        sample_experiment = """
            INSERT INTO experiments (experiment_code, experiment_name, plant_species, stress_type, researcher)
            VALUES (?, ?, ?, ?, ?)
        """
        params = ('EXP001', 'Drought Stress Test', 'Arabidopsis thaliana', 'drought', 'Test Researcher')
        
        if db.execute_query(sample_experiment, params):
            print("✅ Sample experiment added successfully!")
            
            # Show database summary
            db.get_table_info()
        else:
            print("❌ Failed to add sample data")
    else:
        print("❌ Failed to create database")

if __name__ == "__main__":
    test_sqlite()